  unit paint;

  interface

  uses
      SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
      Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, Menus, ComCtrls, MPlayer;

  type
      TForm1 = class(TForm)
      Up: TBitBtn;
      down: TButton;
      Left: TButton;
      Right: TButton;
      spr_bitmap: TImage;
      spr_mask: TImage;
      StatusBar1: TStatusBar;
      Image1: TImage;
      MediaPlayer1: TMediaPlayer;
    MediaPlayer2: TMediaPlayer;
    BitBtn1: TBitBtn;
    Edit1: TEdit;

  procedure FormCreate(Sender: TObject);
  procedure FormPaint(Sender: TObject);
  procedure downClick(Sender: TObject);
  procedure UpClick(Sender: TObject);
  procedure LeftClick(Sender: TObject);
  procedure RightClick(Sender: TObject);
  procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);
  private
         { Private declarations }
  public
         { Public declarations }
  end;

  var
     Form1: TForm1;
     spr_num,anim_speed:integer;
     logical: TBitmap; {Stores the maze graphics }
     BufferBitMap: TBitmap; { draw here when working stuff out }
     score,Total,x,y,counter,last_offset,brush_dirX,next_brush_dirX,brush_dirY,next_brush_dirY:integer;
     newlevel,px,py,painter_last_offset,painter_spr_dirX,painter_spr_dirY:integer;
     room: array[1..20, 1..5] of integer;
     dead,playgame:boolean;
     lives,Brush_offset,painter_offset,directionX,directionY :integer;
     Ch,tot: word;
  implementation

{$R *.DFM}


  procedure medplay (mstart,mend:integer ;wait:boolean);
  begin
     form1.MediaPlayer1.StartPos:=mstart;
     form1.MediaPlayer1.endPos:=mend;
     form1.MediaPlayer1.Wait :=wait;
     form1.MediaPlayer1.Play;
  end;

  procedure finish;
  begin
    form1.image1.picture.LoadFromFile('fin.bmp');
         form1.image1.visible:=true;
         repeat
        Application.ProcessMessages;
  until playgame=true;
  //newlevel:=0;
  end;


  procedure delay(Num:longint);
  var
  tc:longint;
  begin
       tc:=GetTickCount;
  repeat
        //application.ProcessMessages;
  until ((GetTickCount-tc)>=Num);
  end;

  procedure collide;
  begin
  if px+16>=x then
  if px<=x+20 then
  if py+16>=y then
  if py<=y+20 then
  begin
       medplay(830,2400,true);
       dead:=true;
       dec(lives);
       form1.statusbar1.Panels[1].text:='Lives:='+inttostr(lives);
  end;
  end;

  procedure junction;
  begin
       directionX:=0;
       directionY:=0;
  for counter:=1 to 18 do
  begin
  if px=room[counter,1]then
     directionX:=1;
  if py=room[counter,2]then
     directionY:=1;
  if px=room[counter,3]then
     directionX:=1;
  if py=room[counter,4]then
     directionY:=1;
  end;

  if directionX=1 then
  if x<px then
      painter_spr_dirX:=8
  else
      painter_spr_dirX:=2;


  if directionY=1 then
  if y<py then
      painter_spr_dirY:=1
  else
      painter_spr_dirY:=4;
  end;

  procedure newroom;
  var
  F1: textfile;
  begin
    AssignFile(F1, 'level'+inttostr(newlevel)+'.dat');
    Reset(F1);
     counter:=1;
     Read(F1, tot);
    // dec(tot) ;
     repeat
      begin
         read(f1,room[counter,1]);
         read(f1,room[counter,2]);
         read(f1,room[counter,3]);
         read(f1,room[counter,4]);
         room[counter,5]:=(room[counter,3]-room[counter,1])+(room[counter,4]-room[counter,2]) ;
          counter:=counter+1;
      end;
      until Eof(F1);
          CloseFile(F1);
  end;

  procedure whichroom(x1,y1:integer);
  begin
  for counter:=1 to tot do
  if x>=room[counter,1] then
  if x<=room[counter,3] then
  if y>=room[counter,2] then
  if y<=room[counter,4] then
  if logical.canvas.pixels[ room[counter,1]+3, room[counter,2]+3] <>clgreen then
  begin
  if logical.Canvas.Pixels[x1, y1]=cllime  then
       room [counter,5]:=room[counter,5]-1;
  if room[counter,5]<=0 then
  begin
       total:=total-1;
       logical.Canvas.Brush.color :=clgreen;
       logical.Canvas.fillrect(rect(room[counter,1]+3,room[counter,2]+3,room[counter,3]+1-3,room[counter,4]+1-3));
       Form1.Canvas.Brush.color :=clgreen;
       Form1.Canvas.fillrect(rect(room[counter,1]+3,room[counter,2]+3,room[counter,3]+1-3,room[counter,4]+1-3));
       bufferbitmap.Canvas.Brush.color :=clgreen;
       bufferbitmap.Canvas.fillrect(rect(room[counter,1]+3,room[counter,2]+3,room[counter,3]+1-3,room[counter,4]+1-3));

       //form1.Canvas.CopyMode := cmSrccopy;
       form1.Canvas.CopyRect(rect(room[counter,1]+4,room[counter,2]+4,room[counter,3]+1-4,room[counter,4]+1-4),form1.image1.canvas,rect(room[counter,1]+4,room[counter,2]+4,room[counter,3]+1-4,room[counter,4]+1-4));

       //logical.Canvas.CopyMode := cmSrccopy;
       logical.Canvas.CopyRect(rect(room[counter,1]+4,room[counter,2]+4,room[counter,3]+1-4,room[counter,4]+1-4),form1.image1.canvas,rect(room[counter,1]+4,room[counter,2]+4,room[counter,3]+1-4,room[counter,4]+1-4));

      bufferbitmap.Canvas.CopyMode := cmSrccopy;
       bufferbitmap.Canvas.CopyRect(rect(room[counter,1]+4,room[counter,2]+4,room[counter,3]+1-4,room[counter,4]+1-4),form1.image1.canvas,rect(room[counter,1]+4,room[counter,2]+4,room[counter,3]+1-4,room[counter,4]+1-4));

       score:=score+counter*100;
       medplay(0,800,false);
       form1.statusbar1.panels[0].text:='Score:'+inttostr(score);
  end;
  end;
  end;

  procedure Updatebrush (nx,ny,ox,oy:integer);
  var
  fromrect,torect,newrect:TRect;
  begin

       last_offset:=Brush_offset;
       fromrect  := Rect(ox-15,oy-15,ox+15,oy+15);
       torect := Rect(ox-15,oy-15,ox+15,oy+15);
       BufferBitmap.Canvas.CopyMode := cmSrcCopy;
       BufferBitmap.Canvas.CopyRect(torect,logical.canvas, fromrect);

       fromrect  := Rect(Brush_offset+spr_num,0,Brush_offset+31+spr_num,31);
       torect := Rect(nx-15,ny-15,nx+15,ny+15);
       BufferBitmap.Canvas.CopyMode := cmSrcAnd;
       BufferBitmap.Canvas.CopyRect(torect,form1.spr_mask.canvas, fromrect);

       BufferBitmap.Canvas.CopyMode := cmSrcPaint;
       BufferBitmap.Canvas.CopyRect(torect,form1.spr_bitmap.canvas, fromrect);

       fromrect := Rect(ox-15+spr_num,oy-15,ox+15+spr_num,oy+15);
       torect :=  Rect(nx-15,ny-15,nx+15,ny+15);
       UnionRect(newrect,fromrect,torect);

      // Form1.Canvas.CopyMode := cmSrcCopy;
       Form1.Canvas.CopyRect(newrect,BufferBitmap.canvas, newrect);
  end;


  procedure movebrush;
  var
  xx,yy:integer;
  Begin
       xx:=x;yy:=y;
       logical.Canvas.Pen.Color := clblue;
       form1.Canvas.Pen.Color := clblue;
       form1.Canvas.MoveTo(x, y);
       logical.Canvas.MoveTo(x, y);
  if brush_dirX=2 then
  if  logical.Canvas.Pixels[x+2, y] >0 then
  if  logical.Canvas.Pixels[x+2, y] <>clgreen then
  begin
       Brush_offset:=128;
       whichroom(x,y);
       x:=x+2;
  end;


  if brush_dirX=8 then
  if  logical.Canvas.Pixels[x-2, y] >0 then
  if  logical.Canvas.Pixels[x-2, y] <>clgreen then
  begin
       Brush_offset:=192;
       whichroom(x,y);
       x:=x-2;
  end;

      form1.canvas.lineto(x,y);
      logical.canvas.lineto(x,y);

  if brush_dirY=4 then
  if logical.Canvas.Pixels[x, y+2] >0 then
  if logical.Canvas.Pixels[x, y+2] <>clgreen then
  begin
       Brush_offset:=60;
       whichroom(x,y);
       y:=y+2;
  end;

 if brush_dirY=1 then
 if logical.Canvas.Pixels[x, y-2] >0 then
 if logical.Canvas.Pixels[x, y-2] <>clgreen then
 begin
      Brush_offset:=0;
      whichroom(x,y);
      y:=y-2;
  end;

      form1.canvas.lineto(x,y);
      logical.canvas.lineto(x,y);
      Updatebrush(x,y,xx,yy);
      brush_dirX:=next_brush_dirX;
      brush_dirY:=next_brush_dirY;
  end;



///////////////////////////////////////////////////////
  procedure UpdatePainter (nx,ny,ox,oy:integer);
  var
  fromrect,torect,newrect:TRect;
  begin
       painter_last_offset:=painter_offset;

       fromrect  := Rect(ox-15,oy-15,ox+15,oy+15);
       torect := Rect(ox-15,oy-15,ox+15,oy+15);
       BufferBitmap.Canvas.CopyMode := cmSrcCopy;
       BufferBitmap.Canvas.CopyRect(torect,logical.canvas, fromrect);

       fromrect  := Rect(painter_offset+spr_num,0,painter_offset+31+spr_num,31);
       torect := Rect(nx-15,ny-15,nx+15,ny+15);
       BufferBitmap.Canvas.CopyMode := cmSrcAnd;
       BufferBitmap.Canvas.CopyRect(torect,form1.spr_mask.canvas, fromrect);

       BufferBitmap.Canvas.CopyMode := cmSrcPaint;
       BufferBitmap.Canvas.CopyRect(torect,form1.spr_bitmap.canvas, fromrect);

       fromrect := Rect(ox-15+spr_num,oy-15,ox+15+spr_num,oy+15);
       torect :=  Rect(nx-15,ny-15,nx+15,ny+15);
       UnionRect(newrect,fromrect,torect);

       //Form1.Canvas.CopyMode := cmSrcCopy;
       Form1.Canvas.CopyRect(newrect,BufferBitmap.canvas, newrect);
  end;



  procedure movepainter;
  var
  pxx,pyy:integer;
  Begin
       pxx:=px;pyy:=py;
       junction;

  if painter_spr_dirX=2 then
  if  logical.Canvas.Pixels[px+2, py] >0 then
  if  logical.Canvas.Pixels[px+2,py] <>clgreen then
  begin
       painter_offset:=448;
       px:=px+2;
  end;

  if painter_spr_dirX=8 then
  if  logical.Canvas.Pixels[px-2, py] >0 then
  if  logical.Canvas.Pixels[px-2, py] <>clgreen then
  begin
       painter_offset:=384;
       px:=px-2;
  end;

  if painter_spr_dirY=4 then
  if  logical.Canvas.Pixels[px, py+2] >0 then
  if  logical.Canvas.Pixels[px, py+2] <>clgreen then
  begin
       painter_offset:=256;
       py:=py+2;
  end;

  if painter_spr_dirY=1 then
  if  logical.Canvas.Pixels[px, py-2] >0 then
  if  logical.Canvas.Pixels[px, py-2] <>clgreen then
  begin
       painter_offset:=320;
       py:=py-2;
  end;
      Updatepainter(px,py,pxx,pyy);
//form1.canvas.textout(0,0,inttostr(directionX)+'       ');
  end;

  procedure TForm1.FormCreate(Sender: TObject);
  begin
       logical := TBitmap.Create;
       BufferBitmap := TBitmap.Create;
       logical.LoadFromFile('back.bmp');
       BufferBitmap.LoadFromFile('back.bmp');
  end;

{ These procedures happen when the buttons are pressed. Buttons?
Yes, there are four -- one for every directionX. They just don't appear
on the screen, but we use the fact that Delphi allows hotkeys to make
it possible to steer the pacman. Yes, yet more cunning.  }
  procedure TForm1.downClick(Sender: TObject);
  begin
  { Try to move down }
      next_brush_dirY:=4;
  end;

  procedure TForm1.UpClick(Sender: TObject);
  begin
  { Try to move up }
      next_brush_dirY:=1;
  end;

  procedure TForm1.LeftClick(Sender: TObject);
  begin
  { Try to go left }
      next_brush_dirX:=8;
  end;

  procedure TForm1.RightClick(Sender: TObject);
  begin
  { Try to go right }
      next_brush_dirX:=2;
  end;

  procedure init;
  var
fromrect,torect:TRect;
rn:integer;
  begin
  rn:=1+random(3);
     form1.image1.picture.LoadFromFile('fill'+inttostr(rn)+'.bmp');
       newroom;
       x:=room[2,1];
       y:=room[2,2];
       px:=room[1,1];
       py:=room[1,2];
       total:=tot;


       logical.Canvas.Brush.Color := clblack;
       logical.Canvas.Pen.Color := cllime;
       bufferbitmap.Canvas.Brush.Color := clblack;
       bufferbitmap.Canvas.Pen.Color := cllime;
       form1.Canvas.Brush.Color := clblack;
       form1.Canvas.Pen.Color := cllime;

       logical.Canvas.fillrect(rect(0,0,525,349));
       bufferbitmap.Canvas.fillrect(rect(0,0,525,349));
       form1.Canvas.fillrect(rect(0,0,525,349));

  for counter:=1 to tot+1 do
  begin
       logical.Canvas.rectangle(room[counter,1],room[counter,2],room[counter,3]+1,room[counter,4]+1);
       logical.Canvas.rectangle(room[counter,1],room[counter,2],room[counter,3]+1,room[counter,4]+1);
       bufferbitmap.Canvas.rectangle(room[counter,1],room[counter,2],room[counter,3]+1,room[counter,4]+1);
       bufferbitmap.Canvas.rectangle(room[counter,1],room[counter,2],room[counter,3]+1,room[counter,4]+1);
  end;
      fromrect  := Rect(0,0,399,299);
      torect := Rect(50,20,50+399,20+299);
      Form1.Canvas.CopyMode := cmSrcCopy;
      Form1.Canvas.CopyRect(Rect(0,0,639,479), logical.Canvas, Rect(0,0,639,479));
      next_brush_dirY:=0;
      next_brush_dirX:=0;
      brush_dirX:=next_brush_dirX;
      brush_dirY:=next_brush_dirY;

      movebrush;
      movepainter;
      form1.statusbar1.Panels[1].text:='Lives:='+inttostr(lives);
      dead:=false;
      delay(2000);
      bufferbitmap.Canvas.refresh;
      form1.MediaPlayer1.FileName := 'sounds.wav';
      form1.MediaPlayer1.Open;
  end;

  procedure play;
  begin
      // form1.statusbar1.Panels[2].text:='';
  repeat
  if form1.mediaplayer2.mode=mpstopped then
  begin
  form1.mediaplayer2.play;
  end;
      collide;
      movebrush;
      movepainter;
      spr_num:=31;
  if anim_speed>=60 then
      anim_speed:=0;
  if anim_speed <30 then
      spr_num:=0;
      Application.ProcessMessages;
      anim_speed:=anim_speed+1;
 // for slow:=0 to 2000000 do
 //begin

      delay(strtoint(form1.edit1.text));
 // end;
 //delay(14);
  if total<=0 then
  begin
       dead:=true;
       inc(newlevel);
       delay(1000);
       if newlevel=10 then
       begin
       finish;
       end;
       medplay(2450,4000,true);
  end;
  until dead=true ;
  end;


  procedure TForm1.FormPaint(Sender: TObject);
  begin
       image1.refresh;
       lives:=3;
       //form1.bitbtn1.setfocus;
  repeat

  repeat

        Application.ProcessMessages;
  until playgame=true;
        playgame:=false;
        dead:=false;
  repeat
       // statusbar1.Panels[2].text:='      The Pooch';
        init;
        play;
        //statusbar1.font.Color:=clred;
        //statusbar1.Panels[2].text:='     OOOOUCH';
        //delay(2000);
        until lives<=0 ;

  ///////////// end of lives///////////////
        //statusbar1.Panels[2].text:='';
        image1.picture.LoadFromFile('main.bmp');
        image1.visible:=true;
  until dead=true;
  edit1.enabled:=true;
  end;

  procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
  if form1.mediaplayer2.mode=mpplaying then
  begin
       form1.mediaplayer2.Stop;
  end;
       logical.free;
       bufferbitmap.free;
       free;
       halt(1);
  end;




procedure TForm1.BitBtn1Click(Sender: TObject);
begin
edit1.enabled:=false;
  form1.MediaPlayer2.FileName := 'hall.rmi';
   form1.MediaPlayer2.Open;
   form1.MediaPlayer2.play;
  image1.visible:=false;
  playgame:=true;
  newlevel:=0;
end;

end.
{
 And that's it! the End!


 I hope you enjoyed our little jaunt with Delphi. I hope you
 can see that it's a very powerful programming language,
 and is capable of almost everything. Yes, it's a database
 language, but it's a whole lot more besides. You can control
 multimedia files and create huge and reliable projects of
 professional quality. And even better, this was free! To
 my mind, this has been the best magazine give-away ever: a
 full, honest to goodness PC development suite. Heck, you could
 write a killer program and become rich with this. Hmm, now
 that sounds a good idea... I have my eye on a new motorbike...

 I've certainly found it an eye-opener when it comes to programming
 the PC, as it hides all the messy stuff and lets you get on with it.
 In fact, I'm almost tempted to rush out and buy the full version of
 the latest v3 release (gasp! magazine writer buys software shocker!)
 because it's faster and will let me use DirectX. There is also a
 games creation library available which makes it even easier.

 I'll put a link to this on my home web site. Please pay it a
 visit if you want to ask a question, or find a link to other
 sites where you'll find information from people who actually
 know what they are talking about. My web site address is most
 definitely here at:

 http://freespace.virgin.net/john.kennedy

 Appologies once again for the wrong addresses which have
 sneaked out. It was all my fault entirely, and I can only
 grovel for your forgiveness.

 So, the end is really here. Thanks to all who have emailed
 and visited the web site. I'll try and put up the previous
 tutorials, copyright permitting, and any more hints and tips.

 Take my advice and get programming. I want to see your games
 and applications appearing on the PC Format coverdisk. There
 just aren't enough home-grown, bedroom, DIY programmers. With
 Delphi, you have no excuse (other than not understanding the
 tutorials of course) so get to it! Program! Program! Program!

 John
 10/7/98
}
